-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
dofile( "scripts/help_style.lua" );

gCurScreen = 0;

function SetScreen( screen )

	if screen == 1 then
		EnableWindow("helptext1",true)
		EnableWindow("helptext2",false)
	elseif screen ==2 then
		EnableWindow("helptext1",false)
		EnableWindow("helptext2",true)
	end

	gCurScreen = screen ;
end


MakeDialog
{
	-- Name the modal dialog
	name="help1",
	Bitmap
	{
		image="images/backgrounds/bgpopup01",
		x=kCenter,
		y=kCenter,
	
		Bitmap
		{
			image="images/ui/common/popup05",
			x=0,
			y=0,
		};
--Tittle
		Text
		{
			font = BigPopupFont,
			x=kCenter,
			y=kTitleY,
			w=kMax,h=45,
			flags = kHAlignCenter + kVAlignCenter,
			label = "help",
		};
--Header
		Bitmap
		{
			image="images/ui/buttons/box05.png",
			x=kTextHeaderX+12,
			y=kTextHeaderY+27,
			Text
			{
				font = NormalHelpFont2,
				x=10,
				y=5,
				w=kMax,h=45,
				flags = kHAlignLeft + kVAlignCenter,
				label = "help_goal_header",
			};
		};
		Text
		{
			font = PopupFont,
			x=kTextHeaderX,
			y=kTextHeaderY,
			w=kMax,h=45,
			flags = kHAlignLeft + kVAlignCenter,
			label = "help_header_goal",
		};
		Text
		{
			font = NormalHelpFont,
			x=kTextHeaderX+45,
			y=kTextHeaderY+65,
			w=400,h=100,
			flags = kHAlignLeft + kVAlignCenter,
			label = "help_goal_text_1",
		};
--cardio
		Bitmap
		{
			image="images/ui/help/cardio",
			x=542,
			y=174,
			w=70,h=50,
			
		};
		Text
		{
			x=565,
			y=160,
			w=100,h=50,
			font = NormalHelpFont,
			flags = kHAlignLeft + kVAlignCenter,
			label = "type_cardio_upgrade",
			
		};
--strenght
		Bitmap
		{
			image="images/ui/help/strength",
			x=542,
			y=194,
			w=100,h=50,
		};
		Text
		{
			font = NormalHelpFont,
			x=565,
			y=180,
			w=100,h=50,
			flags = kHAlignLeft + kVAlignCenter,
			label = "type_strength_upgrade",
		};
		
		Bitmap
		{
			image="images/ui/help/02",
			x=kTextHeaderX+45,
			y=kTextHeaderY+160,
			Text
			{
				font = NormalHelpFont,
				x=15,
				y=5,
				w=kMax,h=45,
				flags = kHAlignLeft + kVAlignCenter,
				label = "help_goal_text_2",
			};
			Text
			{
				font = {standardFont,10,AquaColor},
				x=52,
				y=151,
				w=100,h=45,
				flags = kHAlignCenter + kVAlignCenter,
				label = "hud.label.goal",
			};
			Text
			{
				font = {standardFont,10,WhiteColor},
				x=52,
				y=151+15,
				w=100,h=45,
				flags = kHAlignCenter + kVAlignCenter,
				label = "help.page.1.goal",
			};
			Text
			{
				font = {standardFont,10,AquaColor},
				x=125,
				y=151,
				w=100,h=45,
				flags = kHAlignCenter + kVAlignCenter,
				label = "hud.label.score",
			};
			Text
			{
				font = {standardFont,14,WhiteColor},
				x=125,
				y=151+15,
				w=100,h=45,
				flags = kHAlignCenter + kVAlignCenter,
				label = "help.page.1.score",
			};
		};
		Bitmap
		{
			image="images/ui/help/01",
			x=kTextHeaderX+335,
			y=kTextHeaderY+160,
			Text
			{
				font = NormalHelpFont,
				x=20,
				y=5,
				w=235,h=65,
				flags = kHAlignLeft + kVAlignCenter,
				label = "help_goal_text_3",
			};
		};
		Bitmap
		{
			image="images/ui/help/jointro",
			x=0,
			y=kCenter-15,
			hflip = true,
			scale=0.77,
		};
		SetStyle(FitnessButtonStyleTittleSmallBlue),
--//Back
		SBButton
		{
			x=kButtonX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconback",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                    PopModal("help1");
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "common.back.label",
		};
--Next
		SBButton
		{
			x=kButtonX+kButtonSpaceX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconplay",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                    SwapToModal("scripts/help2.lua");
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX+kButtonSpaceX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "next",
		};
--Paginate
		Text
		{
			font = SmallFontBlack,
			flags = kHAlignCenter + kVAlignCenter,
			x=kPaginateX,
			y=kPaginateY,
			w=kMax,h=30,
			
			label = "help_paginate_1",
		};
		
		

	}
}

SetScreen(1);
